﻿$packageName = 'vcredist2013'
$installerType = 'exe'
$url = "$(Split-Path -parent $MyInvocation.MyCommand.Definition)\files\vcredist_x86.exe"
$checksum = 'df7f0a73bfa077e483e51bfb97f5e2eceedfb6a3'
$checksumType = 'sha1'
$url64 = "$(Split-Path -parent $MyInvocation.MyCommand.Definition)\files\vcredist_x64.exe"
$checksum64 = '8bf41ba9eef02d30635a10433817dbb6886da5a2'
$checksumType64 = 'sha1'
$silentArgs = '/Q'
$validExitCodes = @(0,3010)  # http://msdn.microsoft.com/en-us/library/aa368542(VS.85).aspx

Install-ChocolateyPackage -PackageName "$packageName" `
                          -FileType "$installerType" `
                          -Url "$url" `
                          -Url64bit "$url64" `
                          -SilentArgs "$silentArgs" `
                          -ValidExitCodes $validExitCodes `
                          -Checksum "$checksum" `
                          -ChecksumType "$checksumType" `
                          -Checksum64 "$checksum64" `
                          -ChecksumType64 "$checksumType64"

if (Get-ProcessorBits 64) {
  Install-ChocolateyPackage -PackageName "$packageName" `
                            -FileType "$installerType" `
                            -Url "$url" `
                            -SilentArgs "$silentArgs" `
                            -ValidExitCodes $validExitCodes `
                            -Checksum "$checksum" `
                            -ChecksumType "$checksumType"
}