﻿$packageName = 'vcredist2012'
$installerType = 'EXE'
$32BitUrl = 'https://download.microsoft.com/download/1/6/B/16B06F60-3B20-4FF2-B699-5E9B7962F9AE/VSU_4/vcredist_x86.exe'
$64BitUrl = 'https://download.microsoft.com/download/1/6/B/16B06F60-3B20-4FF2-B699-5E9B7962F9AE/VSU_4/vcredist_x64.exe'
$silentArgs = '/q /norestart'
$validExitCodes = @(0,3010)

#first install vcredist targetting actual CPU architecture
Install-ChocolateyPackage $packageName $installerType $silentArgs $32BitUrl $64BitUrl -validExitCodes $validExitCodes `
            -checksum B924AD8062EAF4E70437C8BE50FA612162795FF0839479546CE907FFA8D6E386 `
            -checksumType sha256 `
            -checksum64 681BE3E5BA9FD3DA02C09D7E565ADFA078640ED66A0D58583EFAD2C1E3CC4064 `
            -checksumType64 sha256            

$is64bit = Get-ProcessorBits 64;
if($is64bit) {
    #in case of x64 also install x86 vcredist
    Install-ChocolateyPackage $packageName $installerType $silentArgs $32BitUrl -validExitCodes $validExitCodes `
                -checksum B924AD8062EAF4E70437C8BE50FA612162795FF0839479546CE907FFA8D6E386 `
                -checksumType sha256
}
